/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.util.IBellowsConsumerBlock;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TEBellows;
import net.dries007.tfc.objects.te.TECharcoalForge;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.block.Multiblock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockCharcoalForge
extends Block
implements IBellowsConsumerBlock,
ILightableBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    private static final Multiblock CHARCOAL_FORGE_MULTIBLOCK;

    public static boolean isValid(World world, BlockPos pos) {
        return CHARCOAL_FORGE_MULTIBLOCK.test(world, pos);
    }

    public static boolean isValidSide(IBlockState state) {
        return state.func_185904_a() == Material.field_151576_e && state.func_185914_p() && state.func_185915_l();
    }

    public BlockCharcoalForge() {
        super(BlockCharcoalPile.CHARCOAL_MATERIAL);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canIntakeFrom(Vec3i offset, EnumFacing facing) {
        return offset.equals((Object)TEBellows.OFFSET_INSET);
    }

    @Override
    public void onAirIntake(World world, BlockPos pos, int airAmount) {
        TECharcoalForge teForge = Helpers.getTE((IBlockAccess)world, pos, TECharcoalForge.class);
        if (teForge != null) {
            teForge.onAirIntake(airAmount);
        }
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TECharcoalForge te = Helpers.getTE((IBlockAccess)worldIn, pos, TECharcoalForge.class);
        if (te != null && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && worldIn.func_175727_C(pos.func_177984_a())) {
            te.onRainDrop();
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!BlockCharcoalForge.isValid(worldIn, pos)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rng) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.1;
            double z = (double)pos.func_177952_p() + 0.5;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + (double)rng.nextFloat() - 0.5, y, z + (double)rng.nextFloat() - 0.5, 0.0, 0.2, 0.0, new int[0]);
            if (rng.nextInt(3) == 1) {
                world.func_175688_a(EnumParticleTypes.LAVA, x + (double)rng.nextFloat() - 0.5, y, z + (double)rng.nextFloat() - 0.5, 0.0, 0.2, 0.0, new int[0]);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && !BlockCharcoalForge.isValid(worldIn, pos)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TECharcoalForge te = Helpers.getTE((IBlockAccess)worldIn, pos, TECharcoalForge.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 7;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151044_h;
    }

    public int func_180651_a(IBlockState state) {
        return 1;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                ItemStack held = player.func_184586_b(hand);
                if (BlockCharcoalForge.isValid(world, pos) && ItemFireStarter.onIgnition(held)) {
                    TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                    world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                    return true;
                }
            }
            if (!player.func_70093_af()) {
                TFCGuiHandler.openGui(world, pos, player, TFCGuiHandler.Type.CHARCOAL_FORGE);
            }
        }
        return true;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && !entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 2.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TECharcoalForge();
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Items.field_151044_h, 1, 1);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false && (entity == null || !entity.func_70045_F()) ? PathNodeType.DAMAGE_FIRE : null;
    }

    static {
        BiPredicate<World, BlockPos> skyMatcher = World::func_175710_j;
        BiPredicate<World, BlockPos> isValidSide = (world, pos) -> BlockCharcoalForge.isValidSide(world.func_180495_p(pos));
        CHARCOAL_FORGE_MULTIBLOCK = new Multiblock().match(new BlockPos(0, 1, 0), state -> state.func_177230_c() == BlocksTFC.CRUCIBLE || state.func_177230_c() == Blocks.field_150350_a).matchOneOf(new BlockPos(0, 1, 0), new Multiblock().match(new BlockPos(0, 0, 0), skyMatcher).match(new BlockPos(0, 0, 1), skyMatcher).match(new BlockPos(0, 0, 2), skyMatcher).match(new BlockPos(0, 0, -1), skyMatcher).match(new BlockPos(0, 0, -2), skyMatcher).match(new BlockPos(1, 0, 0), skyMatcher).match(new BlockPos(2, 0, 0), skyMatcher).match(new BlockPos(-1, 0, 0), skyMatcher).match(new BlockPos(-2, 0, 0), skyMatcher)).match(new BlockPos(1, 0, 0), isValidSide).match(new BlockPos(-1, 0, 0), isValidSide).match(new BlockPos(0, 0, 1), isValidSide).match(new BlockPos(0, 0, -1), isValidSide).match(new BlockPos(0, -1, 0), isValidSide);
    }
}

